/******************************************************************************
File:        eloCodes.h 
Purpose:     Windows CE. IOCTL, status, and error codes for interfacing to Elo 
touchscreen device drivers.

Copyright 2008 Elo TouchSystems
All rights reserved

Updated:    2008-09-04
******************************************************************************/
#ifndef ELOCODES_H
#define ELOCODES_H

#include <winioctl.h>

#define CE_TYPE 40000

#define MAKE_ELO_IOCTL(c)\
        (ULONG)CTL_CODE(CE_TYPE, 0x900+(c), METHOD_BUFFERED, FILE_ANY_ACCESS)

enum {
// .......................... OPERATION  ......................................
CTL_ELOCFGITEM,  // IocCfgItem. R/W registry items with side-effects. 
CTL_HOLD_PARMS,  // IocHoldParms. Set right click on hold and forced untouch parameters. 
CTL_ON_HOLD,     // Simple. On/off RCOH and forced untouch.
CTL_SOUND,       // Simple. Set sound associated with down, up, drag and RCOH touch.
CTL_ON_TOUCH,    // Simple. Set touch event filter and reporting method (API or mouse). 
CTL_TOUCH,       // Simple. Set touch state.
CTL_ROTATE,      // Simple. Set screen orientation.
CTL_MOUSELIMITS, // IocMouseLimits. Set screen boundary for reporting touch
// ........................... UTILITIES ......................................
CTL_GETLINKTYPE, // Simple. Get link type (serial or USB) of this device.
CTL_REGKEYNAME,  // IocRegKeyName. Get the registry key associated with this touchscreen.
CTL_APIDEVID,    // Simple. Set/get ID for posting global events
CTL_SMARTSET,    // IocSmartSet. Send SmartSet command/reply to the touchscreen controller.           
CTL_DEVCFG,      // IocDevCfg. R/W device configuration data.
// ........................... CALIBRATION ....................................
CTL_SAVECAL,     // Simple. Write calibration parameters to registry and/or controller.
CTL_GETPOINT,    // IocGetPt. Read touchpoint through API.          
CTL_CAL3DAT,     // IocCal3Dat. Set/get calibration parameters 
CTL_EDGECAL,     // IocEdgeCal. Set/get edge cal-based linearity compensation and acceleration.
CTL_LINCOR,      // IocLinCor. Set/get linearity correction parameters
CTL_ACCEL,       // IocAcc. Set/get edge acceleration parameters
CTL_CORNERACC,   // IocCornerAcc. Set/get corner acceleration
// ....................... SPECIAL OPERATIONS .................................
CTL_DEBUGVAL,    // Simple. R/W debug value
};

// .......................... OPERATION  ......................................
#define IOCTL_ELO_CFGITEM               MAKE_ELO_IOCTL( CTL_ELOCFGITEM )
#define IOCTL_ELO_HOLD_PARMS            MAKE_ELO_IOCTL( CTL_HOLD_PARMS )
#define IOCTL_ELO_ON_HOLD               MAKE_ELO_IOCTL( CTL_ON_HOLD )
#define IOCTL_ELO_SOUND                 MAKE_ELO_IOCTL( CTL_SOUND )
#define IOCTL_ELO_ON_TOUCH              MAKE_ELO_IOCTL( CTL_ON_TOUCH )
#define IOCTL_ELO_TOUCH                 MAKE_ELO_IOCTL( CTL_TOUCH )
#define IOCTL_ELO_ROTATE                MAKE_ELO_IOCTL( CTL_ROTATE )
#define IOCTL_ELO_MOUSELIMITS           MAKE_ELO_IOCTL( CTL_MOUSELIMITS )

// ........................... UTILITIES ......................................
#define IOCTL_ELO_GETLINKTYPE           MAKE_ELO_IOCTL( CTL_GETLINKTYPE )
#define IOCTL_ELO_REGKEYNAME            MAKE_ELO_IOCTL( CTL_REGKEYNAME )
#define IOCTL_ELO_APIDEVID              MAKE_ELO_IOCTL( CTL_APIDEVID )
#define IOCTL_ELO_SMARTSET              MAKE_ELO_IOCTL( CTL_SMARTSET )
#define IOCTL_ELO_DEVCFG                MAKE_ELO_IOCTL( CTL_DEVCFG )

// ....................... CALIBRATION ........................
#define IOCTL_ELO_SAVECAL               MAKE_ELO_IOCTL( CTL_SAVECAL )
#define IOCTL_ELO_GETPOINT              MAKE_ELO_IOCTL( CTL_GETPOINT )
#define IOCTL_ELO_CAL3DAT               MAKE_ELO_IOCTL( CTL_CAL3DAT )
#define IOCTL_ELO_EDGECAL               MAKE_ELO_IOCTL( CTL_EDGECAL )
#define IOCTL_ELO_LINCOR                MAKE_ELO_IOCTL( CTL_LINCOR )
#define IOCTL_ELO_ACCEL                 MAKE_ELO_IOCTL( CTL_ACCEL )
#define IOCTL_ELO_CORNERACC             MAKE_ELO_IOCTL( CTL_CORNERACC )
// ....................... SPECIAL OPERATIONS .................................
#define IOCTL_ELO_DEBUGVAL              MAKE_ELO_IOCTL( CTL_DEBUGVAL )

// Error and status codes are negative so that positive values can convey 
// application information, such as device ID, priority level, etc. 
// EloErrSuccess and EloStatOk are the last ones (least negative) so that 
// >= EloErrSuccess or EloStatOk indicates generic success.

typedef enum 
{
    EloErrInvalidCommand = -100,
    EloErrVersionLock,
    EloErrBufferSize,
    EloErrTouchDeviceNotWorking,
    EloErrUnknown,
    EloErrBadDataValue,
    EloErrDeviceBusy,
    EloErrInvalidDevice,
    EloErrSuccess, // Must be last
}   ELO_ERR;

typedef enum 
{
    EloStatConstantTouch = -100,
    EloStatCannotFindController,
    EloStatNoResponse,
    EloStatInvalidResponse,
    EloStatCannotSetBaudRate,
    EloStatCommandNotSent,
    EloStatSystemError,
    EloStatInvalidPort,
    EloStatPortFailedOpen,
    EloStatPortCommandError,
    EloStatPortNoController,
    EloStatUndefinedController,
    EloStatOk, // Must be last 
}   ELO_STAT;

#endif  // ndef ELOCODES_H



